<?php
include 'config.php'; // Include PDO configuration
include 'phpqrcode/qrlib.php'; // Include QR code library

// Function to generate QR code and return base64 image
function generateQRCode($id) {
    // Create a temporary file
    $tempFile = tempnam(sys_get_temp_dir(), 'qr_');
    
    // Generate QR code
    
    QRcode::png("fmsp.us/{$id}", $tempFile, QR_ECLEVEL_L, 4, 1); // Reduced size and margin
    
    // Get image content and convert to base64
    $imageData = file_get_contents($tempFile);
    $base64 = 'data:image/png;base64,' . base64_encode($imageData);
    
    // Remove temporary file
    unlink($tempFile);
    
    return $base64;
}
?>

<!DOCTYPE html>
<html>
<head>
    <link rel="stylesheet" type="text/css" href="displaySelectedLabels.css">
    <style>
        .qr-container {
            position: absolute;
            top: 4.8pt;
            right: 4.8pt;
            display: inline-flex;
            align-items: center;
            padding: 0;
        }
        .qr-container img {
            width: 33.3pt; /* Slightly smaller QR code */
            height: 33.3pt;
            image-rendering: pixelated;
            image-rendering: -moz-crisp-edges;
            image-rendering: crisp-edges;
            -ms-interpolation-mode: nearest-neighbor;
            mix-blend-mode: multiply;
        }
        .url-text {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 4.5pt; /* Smaller font size */
            font-weight: bold;
            writing-mode: vertical-rl;
            transform: rotate(180deg);
            margin: 0 -1pt; /* Tighter margin */
            padding-left: 2.5pt;
            white-space: nowrap;
        }
        .url-text-left {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 3.8pt; /* Smaller font size */
            font-weight: bold;
            writing-mode: vertical-rl;
            transform: rotate(180deg);
            margin: 0 -1pt; /* Tighter margin */
            padding-left: 0.75pt;
            white-space: nowrap;
        }
    </style>
</head>
<body>
    <div id="page-container">
    <?php
    try {
        $selectedIds = isset($_GET['ids']) ? $_GET['ids'] : '';
        
        if (!empty($selectedIds)) {
            $sql = "SELECT id, category_name, title, subtitle FROM tublabels WHERE id IN ($selectedIds) ORDER BY category_name, title, subtitle";
        } else {
            $sql = "SELECT id, category_name, title, subtitle FROM tublabels ORDER BY category_name, title, subtitle";
        }

        $stmt = $conn->prepare($sql);
        $stmt->execute();
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($results) > 0) {
            $count = 0;
            foreach ($results as $row) {
                if ($count % 4 == 0) {
                    if ($count != 0) {
                        echo '</div>';
                    }
                    echo '<div class="page">';
                }
                // Generate QR code for this label
                $qrCode = generateQRCode($row['id']);
                $url = "fmsp.us/" . str_pad($row['id'], 5, "0", STR_PAD_LEFT);
                ?>
                <div class="rectangle">
                    <img src="logo.png" class="logo" alt="Logo">
                    <div class="qr-container">
                        <div class="url-text-left">SCAN FOR INFO</div>
                        <img src="<?php echo $qrCode; ?>" alt="QR Code">
                        <div class="url-text"><?php echo htmlspecialchars($url); ?></div>
                    </div>
                    <p class="text upper-text"><?php echo htmlspecialchars($row["category_name"]); ?></p>
                    <p class="text center-text"><?php echo htmlspecialchars($row["title"]); ?></p>
                    <p class="text lower-text"><?php echo htmlspecialchars($row["subtitle"]); ?></p>
                </div>
                <?php
                $count++;
            }
            echo '</div>';
        } else {
            echo "0 results";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
    ?>
    </div>
</body>
</html>