<?php
// Error handling: Disable error display and enable logging
ini_set('display_errors', 0); // Disable displaying errors to the user
error_reporting(E_ALL); // Log all errors for debugging purposes

// Start the session and ensure session handling happens before any output
session_start();

// Check if the user is logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: ../login.php");
    exit;
}

// Include the header
include "../../private/includes/header.php";
?>
<html>
  <head>
    <title>TubLabels.com</title>
    <link rel="stylesheet" href="index.css">
    <style>
      /* Ensure table grid lines are fully visible */
      table {
        border-collapse: collapse;
        width: 100%;
      }
      th, td {
        border: 1px solid black; /* Force borders for all cells */
        text-align: left;
        padding: 8px;
      }
      th {
        background-color: #f2f2f2; /* Slightly shaded header */
      }
    </style>
  </head>
  <body>
    <div class="container" style="margin-top: 0px;">
      <div class="button-container" style="top: 70px;">
        <button id="selectAllBtn">SELECT ALL</button>
        <button id="addBtn">ADD</button>
        <button id="saveBtn" disabled>SAVE</button>
        <button id="deleteBtn" disabled>DELETE</button>
        <button id="printBtn" disabled>PRINT</button>
      </div>
      <table id="table">
        <thead>
          <tr>
            <th>Select</th>
            <th>ID</th>
            <th>Tag Number</th>
            <th>Category Name</th>
            <th>Title</th>
            <th>Subtitle</th>
            <th>Category ID</th>
            <th>Area ID</th>
            <th>Label Set</th>
            <th>Contents</th>
          </tr>
        </thead>
        <tbody>
        <!-- JavaScript will dynamically populate rows here -->
        </tbody>
      </table>
    </div>
    <script src="index.js?v=<?php echo time(); ?>"></script>
  </body>
</html>
<?php
// Include the footer
include "../../private/includes/footer.php";
?>
