<?php
include "../private/includes/config.php";

$error = '';

// Handle login logic
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    try {
        // Query to find the user
        $stmt = $conn->prepare("SELECT * FROM tublabels_users WHERE username = :username AND password = :password");
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':password', $password);
        $stmt->execute();
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            session_start();
            session_regenerate_id(true); // Regenerate session ID for security
            $_SESSION['logged_in'] = true;
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['is_admin'] = $user['is_admin'];

            // Redirect to the app directory
            header("Location: https://tublabels.com/public/app/index.php");
            exit;
        } else {
            $error = "Invalid username or password.";
        }
    } catch (PDOException $e) {
        $error = "An error occurred while logging in: " . $e->getMessage();
    }
}

// Include the header AFTER login logic to avoid "headers already sent"
$title = "TubLabels -- Member Login"; // Set the page title
include "../private/includes/header.php";
?>
<h1>Welcome to the TubLabels Member's Area!</h1>
<?php if ($error): ?>
    <p style="color: red;"><?php echo $error; ?></p>
<?php endif; ?>

<div style="
    display: flex; 
    justify-content: center; 
    align-items: flex-start; 
    box-sizing: border-box; 
    background-color: #fff; /* White background */
    padding-top: 50px; /* Adjustable spacing from the top */
">
    <div style="
        background-color: #fff; 
        padding: 20px 30px; 
        border-radius: 10px; 
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2); 
        width: 100%; 
        max-width: 400px; 
        text-align: center;
    ">
        <form method="POST" action="" style="width: 100%;">
            
            <label for="username" style="
                font-size: 1rem; 
                display: block; 
                margin-bottom: 5px; 
                text-align: left;
            ">Username:</label>
            <input type="text" name="username" id="username" required style="
                width: 100%; 
                padding: 10px; 
                font-size: 1rem; 
                margin-bottom: 15px; 
                border: 1px solid #ccc; 
                border-radius: 5px; 
                box-sizing: border-box;
            ">
            
            <label for="password" style="
                font-size: 1rem; 
                display: block; 
                margin-bottom: 5px; 
                text-align: left;
            ">Password:</label>
            <input type="password" name="password" id="password" required style="
                width: 100%; 
                padding: 10px; 
                font-size: 1rem; 
                margin-bottom: 15px; 
                border: 1px solid #ccc; 
                border-radius: 5px; 
                box-sizing: border-box;
            ">
            
            <button type="submit" style="
                width: 100%; 
                padding: 10px; 
                font-size: 1rem; 
                background-color: #007bff; 
                color: #fff; 
                border: none; 
                border-radius: 5px; 
                cursor: pointer; 
                transition: background-color 0.3s ease;
            " 
            onmouseover="this.style.backgroundColor='#0056b3'" 
            onmouseout="this.style.backgroundColor='#007bff'">
                Login
            </button>
        </form>
    </div>
</div>


    
<?php include "../private/includes/footer.php"; ?>
