<?php
session_start(); // Start the session

// Check if the user is logged in
$isLoggedIn = isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;
$username = $isLoggedIn ? ucwords(htmlspecialchars($_SESSION['username'])) : "Guest";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/public/assets/css/styles.css">
    <title>TubLabels</title>
</head>
<body>
    <header style="
        position: fixed; /* Makes the header sticky */
        top: 0;
        left: 0;
        width: 100%;
        background-color: black;
        color: #ffcc00;
        z-index: 1000; /* Ensures the header stays above other content */
    ">
        <div style="
            max-width: 1200px;
            margin: 0 auto;
            padding: 10px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        ">
            <!-- Logo Section -->
            <div style="font-size: 2rem; font-weight: bold;">
                <a href="/public/index.php" style="color: #ffcc00; text-decoration: none;">TubLabels</a>
            </div>

            <!-- User Info Section -->
            <div style="text-align: right;">
                <?php if ($isLoggedIn): ?>
                    <div style="font-size: 1rem; font-weight: bold;">Welcome, <?php echo $username; ?>!</div>
                    <a href="/public/logout.php" style="
                        color: #ffcc00;
                        text-decoration: none;
                        font-weight: bold;
                        font-size: 1rem;
                    ">Log Out</a>
                <?php else: ?>
                    <div style="font-size: 1rem; font-weight: bold;"><a href="/public/login.php" style="
                        color: #ffcc00;
                        text-decoration: none;
                        font-weight: bold;
                        font-size: 1rem;
                    ">Member</a></div>
                    
                    <a href="/public/login.php" style="
                        color: #ffcc00;
                        text-decoration: none;
                        font-weight: bold;
                        font-size: 1rem;
                    ">Log In</a>
                <?php endif; ?>
            </div>
        </div>
    </header>
    <main style="margin-top: 70px;"> <!-- Adjust margin to match header height -->
