<?php
include 'config.php';

// Get and decode JSON data
$data = json_decode(file_get_contents("php://input"), true);

if ($data === null) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON data received']);
    exit;
}

try {
    // Create placeholders for prepared statement
    $placeholders = str_repeat('?,', count($data) - 1) . '?';
    
    // Prepare the delete statement
    $stmt = $conn->prepare("DELETE FROM tublabels WHERE id IN ($placeholders)");
    
    // Execute with the array of IDs
    $stmt->execute($data);
    
    echo json_encode(['success' => true, 'message' => 'Records deleted successfully']);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
}
?>