<?php
include 'config.php';
?>

<!DOCTYPE html>
<html>
<head>
  <style>
    body {
      font-family: Arial, sans-serif;
    }
    table {
      border-collapse: collapse;
      width: 100%;
    }
    td, th {
      border: 1px solid #dddddd;
      text-align: left;
      padding: 8px;
    }
    tr:nth-child(even) {
      background-color: #dddddd;
    }
    input[type=checkbox] {
      margin-right: 10px;
    }
  </style>
</head>
<body>
  <div id="page-container">
    <?php
    $selectedIds = isset($_GET['ids']) ? $_GET['ids'] : '';
    if (!empty($selectedIds)) {
        $sql = "SELECT category_name, title, subtitle FROM tublabels WHERE id IN ($selectedIds) ORDER BY category_name, title, subtitle";
    } else {
        $sql = "SELECT category_name, title, subtitle FROM tublabels ORDER BY category_name, title, subtitle";
    }
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        echo "<table>";
        // Add headers
        echo "<tr>";
        echo "<th></th>";
        echo "<th>CATEGORY NAME</th>";
        echo "<th>TITLE</th>";
        echo "<th>SUBTITLE</th>";
        echo "</tr>";

        // Loop through the records and create rows
        while($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td><input type='checkbox' unchecked></td>";
            echo "<td>" . htmlspecialchars(trim($row["category_name"])) . "</td>";
            echo "<td>" . htmlspecialchars(trim($row["title"])) . "</td>";
            echo "<td>" . htmlspecialchars(trim($row["subtitle"])) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "0 results";
    }
    $conn->close();
    ?>
  </div>
</body>
</html>
