<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

set_exception_handler(function($exception) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'error' => $exception->getMessage()]);
    exit();
});

include 'config.php'; // Ensure this uses PDO

$response = ['success' => false, 'error' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');

    try {
        // Log POST request
        file_put_contents('log.txt', "POST request received\n", FILE_APPEND);

        // Decode JSON changes
        $changes = json_decode($_POST['changes'], true);
        if (!$changes) {
            throw new Exception("Invalid JSON input.");
        }
        file_put_contents('log.txt', "Changes: " . print_r($changes, true) . "\n", FILE_APPEND);

        foreach ($changes as $change) {
            if (isset($change['newRecord']) && $change['newRecord']) {
                // New record insertion
                $record = $change['record'];
                $columns = implode(", ", array_keys($record));
                $placeholders = implode(", ", array_fill(0, count($record), "?"));

                $sql = "INSERT INTO tublabels ($columns) VALUES ($placeholders)";
                $stmt = $conn->prepare($sql);
                $stmt->execute(array_values($record));
            } else {
                // Update existing record
                $id = $change['id'];
                $field = $change['field'];
                $newValue = $change['newValue'];

                $sql = "UPDATE tublabels SET $field = :newValue WHERE id = :id";
                $stmt = $conn->prepare($sql);
                $stmt->bindParam(':newValue', $newValue);
                $stmt->bindParam(':id', $id);
                $stmt->execute();
            }
        }

        $response['success'] = true;
    } catch (Exception $e) {
        file_put_contents('log.txt', "Error: " . $e->getMessage() . "\n", FILE_APPEND);
        $response['error'] = $e->getMessage();
    }
}

// Send JSON response
echo json_encode($response);
?>
