<?php
$title = "TubLabels -- Home"; // Set a custom title for this page
include "../private/includes/header.php"; // Include the header
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    <link rel="stylesheet" href="assets/css/styles.css">
    <style>
        /* Inline styles for hero container */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }

        .hero-container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px 30px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
            margin-top: 100px; /* Adjust this value to move the div down */
        }

        .hero-container h1 {
            font-size: 2.5em;
            margin-bottom: 10px;
        }

        .hero-container .brand {
            color: #ffcc00; /* Yellow-orange */
        }

        .hero-container p {
            font-size: 1.2em;
            margin-bottom: 10px;
            line-height: 1.6;
        }

        .features {
            text-align: left;
            margin: 20px 0;
            padding: 0;
            list-style-type: none;
        }

        .features li {
            margin-bottom: 15px;
            line-height: 1.5;
            font-size: 1.1em;
        }

        .features li strong {
            color: #333;
        }

        .cta {
            margin-top: 30px;
            margin-bottom: 30px;
        }

        .primary-button {
            background-color: #ffcc00;
            color: #333;
            border: none;
            padding: 12px 20px;
            font-size: 1.2em;
            font-weight: bold;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none; /* Removes underline */
            transition: background-color 0.3s;
        }

        .primary-button:hover {
            background-color: #e6b800;
            text-decoration: none; /* Removes underline */
        }
        
        .description {
          display: block; /* Ensures it starts on a new line */
          margin-left: 20px; /* Adjust this value for desired indentation */
        }   
    </style>
</head>
<body>
    <div class="hero-container">
        <h1>Organize Your Space with <span class="brand">TubLabels</h1>
        <p>Are you tired of digging through endless tubs, boxes, or containers just to find one item? TubLabels is here to revolutionize the way you organize your storage.</p>
        <ul class="features">
            <li><strong>List Your Containers:</strong><br>
                <span class="description">Easily create a digital inventory of all your tubs, boxes, and storage containers.</span></li>
            <li><strong>Categorize with Ease:</strong><br>
                <span class="description">Assign custom categories to each container for effortless sorting.</span></li>
            <li><strong>Add Details:</strong><br>
                <span class="description">Include subtitles for container titles and a full list of contents for ultimate clarity.</span></li>
            <li><strong>Edit and Sort:</strong><br>
                <span class="description">Make updates in real time and arrange your inventory exactly how you want it.</span></li>
            <li><strong>Print Custom Labels:</strong><br>
                <span class="description">Generate and print perfectly formatted labels that stick to your containers, making them instantly identifiable.</span></li>
        </ul>
        <h2>Ask Your Containers Anything</h2>
        <p>TubLabels goes beyond organization with our powerful AI assistant. Need to find something fast? Simply ask questions like, "Do we have any glue?" and our chatbot will guide you:</p>
        <ul class="features">
            <li><strong>Interactive Queries:</strong><br>
                <span class="description">Get tailored responses like, "What kind of glue do you need?" or "What do you need to glue?"</span></li>
            <li><strong>Smart Search Results:</strong><br>
                <span class="description">Find the exact container(s) to check based on titles, subtitles, or detailed contents you’ve entered.</span></li>
        </ul>
        <div class="cta">
            <a href="<?php echo $isLoggedIn ? '/public/app/index.php' : '/public/login.php'; ?>" class="primary-button">
                Start Organizing Today!
            </a>
        </div>
    </div>

</body>
</html>
<?php include "../private/includes/footer.php"; // Include the footer ?>
